% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_field_xlsx.R
\name{read_field_xlsx}
\alias{read_field_xlsx}
\title{Read Field Data in an Excel Workbook}
\usage{
read_field_xlsx(
  path,
  sheet = NULL,
  pattern = "^[0-9]{1,2}-[0-9]{1,2}-[0-9]{2,4}$"
)
}
\arguments{
\item{path}{'character' string.
Path to the Excel workbook (xlsx) to read.}

\item{sheet}{'character' vector.
Name of the Excel worksheet(s) to read.
Sheet names may also be specified via the \code{pattern} argument.
If neither argument specifies the sheet, defaults to the first sheet in the workbook.}

\item{pattern}{'character' string.
A pattern (regular expression) used to identify worksheet names in the workbook.}
}
\value{
A list with data frame components.
}
\description{
Read worksheet(s) of Multilevel Monitoring System (MLMS) field data in an Excel workbook.
}
\examples{
path <- system.file("extdata/ex-field.xlsx", package = "mlms")
l <- read_field_xlsx(path, sheet = "06-30-2022")
str(l, max.level = 1)
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
