% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitions_rand.R
\name{random.holdout}
\alias{random.holdout}
\title{Hold-out partitioning of an mldr object}
\usage{
random.holdout(mld, p = 60, seed = 10, get.indices = FALSE)
}
\arguments{
\item{mld}{The \code{mldr} object to be partitioned}

\item{p}{The percentage of instances to be selected for the training partition}

\item{seed}{The seed to initialize the random number generator. By default is 10. Change it if you want to obtain partitions containing
different samples, for instance to use a 2x5 fcv strategy}

\item{get.indices}{A logical value indicating whether to return lists of indices or lists of \code{"mldr"} objects}
}
\value{
An \code{mldr.folds} object. This is a list containing k elements, one for each fold. Each element is made up
of two mldr objects, called \code{train} and \code{test}
}
\description{
Random partitioning
}
\examples{
\dontrun{
library(mldr.datasets)
library(mldr)
parts.emotions <- random.holdout(emotions, p = 70)
summary(parts.emotions$train)
summary(parts.emotions$test)
}
}
