% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkinds.R
\name{mkinds}
\alias{mkinds}
\alias{print.mkinds}
\title{A dataset class for mkin}
\usage{
\method{print}{mkinds}(x, data = FALSE, ...)
}
\arguments{
\item{x}{An \link{mkinds} object.}

\item{data}{Should the data be printed?}

\item{\dots}{Not used.}
}
\description{
At the moment this dataset class is hardly used in mkin. For example,
mkinfit does not take mkinds datasets as argument, but works with dataframes
such as the on contained in the data field of mkinds objects. Some datasets
provided by this package come as mkinds objects nevertheless.
}
\examples{

mds <- mkinds$new("FOCUS A", FOCUS_2006_A)
print(mds)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{title}}{A full title for the dataset}

\item{\code{sampling_times}}{The sampling times}

\item{\code{time_unit}}{The time unit}

\item{\code{observed}}{Names of the observed variables}

\item{\code{unit}}{The unit of the observations}

\item{\code{replicates}}{The maximum number of replicates per sampling time}

\item{\code{data}}{A data frame with at least the columns name, time
and value in order to be compatible with mkinfit}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-mkinds-new}{\code{mkinds$new()}}
\item \href{#method-mkinds-clone}{\code{mkinds$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mkinds-new"></a>}}
\if{latex}{\out{\hypertarget{method-mkinds-new}{}}}
\subsection{Method \code{new()}}{
Create a new mkinds object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mkinds$new(title = "", data, time_unit = NA, unit = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{The dataset title}

\item{\code{data}}{The data}

\item{\code{time_unit}}{The time unit}

\item{\code{unit}}{The unit of the observations}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mkinds-clone"></a>}}
\if{latex}{\out{\hypertarget{method-mkinds-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mkinds$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
