# $Id: mkinerrmin.R 59 2010-07-28 12:29:15Z jranke $

# Copyright (C) 2010 Johannes Ranke
# Contact: mkin-devel@lists.berlios.de

# This file is part of the R package mkin

# mkin is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.

# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.

# You should have received a copy of the GNU General Public License along with
# this program. If not, see <http://www.gnu.org/licenses/>

mkinerrmin <- function(errdata, n.parms, alpha = 0.05)
{
  means.mean <- mean(errdata$value_mean, na.rm=TRUE)

	df = length(errdata$value_mean) - n.parms
  
	f <- function(err)
	{
		(sum((errdata$value_mean - errdata$value_pred)^2/((err * means.mean)^2)) - 
		 qchisq(1 - alpha,df))^2
	}
	err.min <- optimize(f, c(0.01,0.9))$minimum
	return(list(err.min = err.min, n.optim = n.parms, df = df))
}
