% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_dynamics.R
\name{resource_params}
\alias{resource_params}
\alias{resource_params<-}
\title{Resource parameters}
\usage{
resource_params(params)

resource_params(params) <- value
}
\arguments{
\item{params}{A MizerParams object}

\item{value}{A named list of resource parameters.}
}
\description{
The recommended way to change the resource dynamics parameters is to use
\code{\link[=setResource]{setResource()}}. The \code{resource_params} list contains values that are helpful
in setting up the actual size-dependent parameters with \code{\link[=setResource]{setResource()}}. If
you have specified a custom resource dynamics function that requires
additional parameters, then these should also be added to the
\code{resource_params} list.
}
\details{
The \code{resource_params} list will at least contain the slots \code{kappa}, \code{lambda},
\code{w_pp_cutoff} and \code{n}.

The resource parameter \code{n} is the exponent for the power-law form for the
replenishment rate \eqn{r_R(w)}: \deqn{r_R(w) = r_R\, w^{n-1}.}{r_R(w) = r_R
w^{n-1}.}

The resource parameter \code{lambda} (\eqn{\lambda}) is the exponent for the
power-law form for the carrying capacity \eqn{c_R(w)} and \code{w_pp_cutoff} is
its cutoff value: \deqn{c_R(w) = c_R w^{-\lambda}} for all \eqn{w} less than
\code{w_pp_cutoff} and zero for larger sizes.

The resource parameter \code{kappa} (\eqn{\kappa}) determines the initial resource
abundance: \deqn{N_R(w) = \kappa\, w^{-\lambda}}{c_R(w) = \kappa
w^{-\lambda}} for all \eqn{w} less than \code{w_pp_cutoff} and zero for larger
sizes.
}
