% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misuvi_load.R
\name{misuvi_load}
\alias{misuvi_load}
\title{Load MI-SUVI Data}
\usage{
misuvi_load(geography = "county", type = "metrics", moe = FALSE)
}
\arguments{
\item{geography}{Choose the geographic level you want returned to you. "county" or "zcta".}

\item{type}{Select the type of data frame you would like. Options include "metrics", "percentiles", "zcores", and "ranks".}

\item{moe}{Logical -- choose whether margin of error variables are returned. This applies to the "metrics" data sets only.}
}
\value{
A clean data.frame of MI-SUVI data.
}
\description{
This function allows the user to select the MI-SUVI data set they want returned.
}
\examples{
zcta_metrics <- misuvi_load("zcta", "metrics")
county_zscores <- misuvi_load("county", "zscores")


}
