% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.check.R
\name{df.check}
\alias{df.check}
\title{Data Check}
\usage{
df.check(data, print = c("dim", "names", "head", "tail"), n = 4,
         digits = 3, width = 20, row.names = TRUE, row.names.col = "gray2",
         message = TRUE, message.col = "b.blue", check = TRUE, output = TRUE)
}
\arguments{
\item{data}{a data frame.}

\item{print}{a character string or character vector indicating which
results to show on the console, i.e., \code{"dim"}, for
the number of rows and number of columns, \code{"names"}
for the variable names, \code{"head"} for the first rows
of the data frame, and \code{"tail"} for the last rows
of the data frame.}

\item{n}{a numeric value indicating the number of rows to be
printed on the console.}

\item{digits}{a numeric value indicating the maximum number of decimal
places to be used.}

\item{width}{a numeric value indicating the maximum width of the
character strings in the vector.}

\item{row.names}{logical: if \code{TRUE}, row names of the data frame are
printed on the console.}

\item{row.names.col}{a character string indicating the text color for the row
names, see \code{color} argument of the \code{\link{chr.color}}
function.}

\item{message}{logical: if \code{TRUE}, number of remaining rows and
columns are printed on the console.}

\item{message.col}{a character string indicating the text color for the
number of remaining rows and columns printed on the
console, see \code{color} argument of the
\code{\link{chr.color}} function.}

\item{check}{logical: if \code{TRUE} (default), argument specification
is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the
console.}
}
\description{
This function is a wrapper around the functions \code{dim} for the number of
rows and columns, \code{names} for the variable names, \code{df.head} for the
first rows, and \code{df.tail} for the last rows of a data frame.
}
\details{
Note that this function only provides a basic data check suitable for checking
a data frame after importing data into R and is not designed to offer a thorough
data check (e.g., identifying duplicate IDs or inconsistencies in the data).
}
\examples{
# Example 1: Check data frame mtcars
df.check(mtcars)
}
\seealso{
\code{\link{df.head}}, \code{\link{df.head}},
}
\author{
Takuya Yanagida
}
