% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.prop.R
\name{na.prop}
\alias{na.prop}
\title{Proportion of Missing Data for Each Case}
\usage{
na.prop(..., data = NULL, digits = 2, append = TRUE, name = "na.prop",
        as.na = NULL, check = TRUE)
}
\arguments{
\item{...}{a matrix or data frame with incomplete data, where missing
values are coded as \code{NA}. Alternatively, an expression
indicating the variable names in \code{data} e.g.,
\code{na.prop(x1, x2, x3, data = dat)}. Note that the operators
\code{.}, \code{+}, \code{-}, \code{~}, \code{:}, \code{::},
and \code{!} can also be used to select variables, see 'Details'
in the \code{\link{df.subset}} function.}

\item{data}{a data frame when specifying one or more variables in the
argument \code{...}. Note that the argument is \code{NULL}
when specifying a matrix or data frame for the argument \code{...}.}

\item{name}{a character string indicating the name of the variable appended
to the data frame specified in the argument \code{data} when
\code{append = TRUE}.}.

\item{append}{logical: if \code{TRUE} (default), variable with proportion of
missing data is appended to the data frame specified in the
argument \code{data}}

\item{digits}{an integer value indicating the number of decimal places to be
used for displaying proportions.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns a numeric vector with the same length as the number of rows in \code{x}
containing the proportion of missing data.
}
\description{
This function computes the proportion of missing data for each case in a matrix
or data frame.
}
\examples{
# Example 1a: Compute proportion of missing data for each case in the data frame
na.prop(airquality)

# Example 1b: Alternative specification using the 'data' argument,
# append proportions to the data frame 'airquality'
na.prop(., data = airquality)
}
\references{
Enders, C. K. (2010). \emph{Applied missing data analysis}. Guilford Press.

Graham, J. W. (2009). Missing data analysis: Making it work in the real world.
\emph{Annual Review of Psychology, 60}, 549-576.
https://doi.org/10.1146/annurev.psych.58.110405.085530

van Buuren, S. (2018). \emph{Flexible imputation of missing data} (2nd ed.).
Chapman & Hall.
}
\seealso{
\code{\link{as.na}}, \code{\link{na.as}}, \code{\link{na.auxiliary}},
\code{\link{na.coverage}}, \code{\link{na.descript}}, \code{\link{na.indicator}},
\code{\link{na.pattern}}, \code{\link{na.test}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
