% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.multilevel.descript.R
\name{print.multilevel.descript}
\alias{print.multilevel.descript}
\title{Print multilevel.descript object}
\usage{
\method{print}{multilevel.descript}(x, digits = x$args$digits,
      icc.digits = x$args$icc.digits, check = TRUE, ...)
}
\arguments{
\item{x}{\code{multilevel.descript} object.}

\item{digits}{an integer value indicating the number of decimal places to be used.}

\item{icc.digits}{an integer indicating the number of decimal places to be used for displaying
intraclass correlation coefficients.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{multilevel.descript} object
}
\examples{
dat <- data.frame(id = c(1, 2, 3, 4, 5, 6, 7, 8, 9),
                  group = c(1, 1, 1, 1, 2, 2, 3, 3, 3),
                  x1 = c(2, 3, 2, 2, 1, 2, 3, 4, 2),
                  x2 = c(3, 2, 2, 1, 2, 1, 3, 2, 5),
                  x3 = c(2, 1, 2, 2, 3, 3, 5, 2, 4))

# Multilevel descriptve statistics for x1
dat.ml.descript <- multilevel.descript(dat$x1, group = dat$group, output = FALSE)

# Print multilevel.descript object with 5 digits for displaying ICC
print(dat.ml.descript, icc.digits = 5)
}
\seealso{
\code{\link{multilevel.descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
