% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IRW.R
\name{IRW}
\alias{IRW}
\alias{NestedSampling}
\alias{TPA}
\title{Increasing Randow Walk}
\usage{
IRW(dimension, lsf, N = 10, q = Inf, Nevent = Inf, particles,
  LSF_particles = lsf(particles), K, burnin = 20, sigma = 0.3,
  last.return = TRUE, use.potential = TRUE, plot = FALSE,
  print_plot = FALSE, output_dir = NULL)
}
\arguments{
\item{dimension}{dimension of the input space.}

\item{lsf}{limit state function.}

\item{N}{number of particules.}

\item{q}{level until which the randow walk is to be generated.}

\item{Nevent}{the number of desired events.}

\item{particles}{to start with some given particles.}

\item{LSF_particles}{value of the \code{lsf} on these particles.}

\item{K}{kernel transition for conditional generations.}

\item{burnin}{burnin parameter.}

\item{sigma}{radius parameter for \code{K}.}

\item{last.return}{if the last event should be returned.}

\item{use.potential}{tu use a \sQuote{potential} matrix to select starting point not
directly related to the sample to be moved with the MH algorithm.}

\item{plot}{if \code{TRUE}, the algorithm plots the evolution of the particles. This
requieres to evaluate the \code{lsf} on a grid and is only for visual purpose.}

\item{print_plot}{if TRUE, print the updated plot after each iteration. This might
be slow; use with a small \code{N}. Otherwise it only prints the final plot.}

\item{output_dir}{if plots are to be saved in pdf in a given directory. This will
be pasted with \sQuote{_IRW.pdf}. Together with \code{print_plot==TRUE} this will
produce a pdf with a plot at each iteration, enabling \sQuote{video} reconstitution
of the algorithm.}
}
\value{
An object of class \code{list} containing the following data:
\item{L}{the events of the random walk.}
\item{M}{the total number of iterations.}
\item{Ncall}{the total number of calls to the \code{lsf}.}
\item{particles}{a matrix containing the final particles.}
\item{LSF_particles}{the value of \code{lsf} on the \code{particles}.}
\item{q}{the threshold considered when generating the random walk.}
\item{Nevent}{the target number of events when generating the random walk.}
\item{Nwmoves}{the number of rejected transitions, ie when the proposed point was not stricly
greater/lower than the current state.}
\item{acceptance}{a vector containing the acceptance rate for each use of the MH algorithm.}
}
\description{
Simulate the increasing random walk associated with a real-valued continuous
random variable.
}
\details{
This function lets generate the increasing random walk associated with a continous
real-valued random variable of the form \code{Y = lsf(X)} where \code{X} is
vectorial random variable.

This random walk can be associated with a Poisson process with parameter
\code{N} and hence the number of iterations before a given threshold \code{q}
is directly related to P[ lsf(X) > q]. It is the core tool of algorithms
such as nested sampling, Last Particle Algorithm or Tootsie Pop Algorithm.

Bascially for \code{N = 1}, it generates a sample \eqn{Y = lsf(X)} and iteratively
regenerates greater than the sought value: \eqn{Y_{n+1} \sim \mu^Y( \cdot \mid Y > Y_n}. This
regeneration step is done with a Metropolis-Hastings algorithm and that is why it is usefull
to consider generating several chains all together (\code{N > 1}).

The algorithm stops when it has simulated the required number of events \code{Nevent} or when
it has reached the sought threshold \code{q}.
}
\note{
Problem is supposed to be defined in the standard space. If not,
use \code{\link{UtoX}} to do so. Furthermore, each time a set of vector
is defined as a matrix, \sQuote{nrow} = \code{dimension} and
\sQuote{ncol} = number of vector to be consistent with \code{as.matrix}
transformation of a vector.

Algorithm calls lsf(X) (where X is a matrix as defined previously) and
expects a vector in return. This allows the user to optimise the computation
of a batch of points, either by vectorial computation, or by the use of
external codes (optimised C or C++ codes for example) and/or parallel
computation; see examples in \link{MonteCarlo}.
}
\examples{
# Get faililng samples for the kiureghian limit state function
# Failure is defined as lsf(X) < 0 so we have to invert the lsf
lsf <- function(x) -1*kiureghian(x)
\dontrun{
fail.samp <- IRW(2, lsf, q = 0, N = 10, plot = TRUE)
}
}
\author{
Clement WALTER \email{clement.walter@cea.fr}
}
\references{
\itemize{
\item C. Walter:\cr
\emph{Moving Particles: a parallel optimal Multilevel Splitting method
with application in quantiles estimation and meta-model based algorithms}\cr
Structural Safety, 55, 10-25.\cr

\item C. Walter:\cr
\emph{Point Process-based Monte Carlo estimation}\cr
arXiv preprint arXiv:1412.6368.\cr

\item J. Skilling:\cr
\emph{Nested sampling for general Bayesian computation}\cr
Bayesian Analysis, 1(4), 833-859.\cr

\item M. Huber \& S. Schott:\cr
\emph{Using TPA for Bayesian inference}\cr
Bayesian Statistics 9, 9, 257.\cr

\item A. Guyader, N. Hengartner and E. Matzner-Lober:\cr
\emph{Simulation and estimation of extreme quantiles and extreme
probabilities}\cr
Applied Mathematics \& Optimization, 64(2), 171-196.
}
}
\seealso{
\code{\link{MP}}
}

