% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeMPprelim.R
\name{makeMPprelim}
\alias{makeMPprelim}
\title{Make MP preliminary investigation data simulations: a function for obtaining a database of preliminary investigation data for a missing child search.}
\usage{
makeMPprelim(
  dateinit = "1975/01/01",
  scenario = 1,
  femaleprop = 0.5,
  ext = 100,
  numsims = 10000,
  seed = 123,
  monthprob = c(0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1),
  region = c("Cuyo", "Patagonia", "Central region", "North west region", "Litoral",
    "Buenos Aires"),
  regionprob = c(0.1, 0.1, 0.1, 0.1, 0.1, 0.5)
)
}
\arguments{
\item{dateinit}{Minimun birth date of simulated persons of interest.}

\item{scenario}{Birth date distribution scenarios: (1) non-uniform, (2) uniform.}

\item{femaleprop}{Proportion of females.}

\item{ext}{Time extension for minimun birth date, rang in scenario 1 and days in scenario 2.}

\item{numsims}{Number of simulated POIs.}

\item{seed}{Select a seed for simulations. If it is defined, results will be reproducible. Suggested, seed = 123.}

\item{monthprob}{Pregnancy month probability at the moment of abduction.}

\item{region}{Birth region or place, argentine regions are listed as default.}

\item{regionprob}{Birth region or place proportions.}
}
\value{
An object of class data.frame with preliminary investigation data.
}
\description{
Make MP preliminary investigation data simulations: a function for obtaining a database of preliminary investigation data for a missing child search.
}
\examples{
makeMPprelim(
  dateinit = "1975/01/01",
  scenario = 1,
  femaleprop = 0.5,
  ext = 100,
  numsims = 10000,
  seed = 123,
  monthprob = c(0.1, 0.1, 0.1,0.1, 0.1, 0.1,0.1, 0.1, 0.1,0.1),
  region = c("Cuyo", "Patagonia", "Central region", "North west region", "Litoral",
            "Buenos Aires"),
  regionprob = c(0.1, 0.1, 0.1, 0.1, 0.1, 0.5)
  )
}
