% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence.R
\name{grevcomp}
\alias{grevcomp}
\title{Get reverse complement of DNA sequence}
\usage{
grevcomp(seq)
}
\arguments{
\item{seq}{A character vector containing DNA sequences (using A,C,G,T). Ignores other characters and NA values.}
}
\value{
A character vector of the same length as the input, containing the reverse
        complement sequences
}
\description{
Takes a DNA sequence string and returns its reverse complement.
}
\examples{
grevcomp("ACTG") # Returns "CAGT"
grevcomp(c("ACTG", "GGCC")) # Returns c("CAGT", "GGCC")
grevcomp(c("ACTG", NA, "GGCC")) # Returns c("CAGT", NA, "GGCC")

}
