# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name ntri
#' @keywords triangle triangular number
#' @author Sven E. Templer (\email{sven.templer@@gmail.com})
#' @title Return Triangular Numbers
#' @description
#' Return the series of triangular (/triangle) numbers up to a number of
#' \code{n} rows of a triangle. The series has the entry number "A000217"
#' at \url{https://oeis.org/} and starts like this: 0, 1, 3, 6, 10, ...
#' @param n Positive integer value for number of triangle rows.
#' @return
#' Returns an integer vector of length \code{n}.
#' @import Rcpp
#' @export ntri
ntri <- function(n) {
    .Call('miscset_ntri', PACKAGE = 'miscset', n)
}

#' @name sortable
#' @keywords table sort
#' @author Sven E. Templer (\email{sven.templer@@gmail.com})
#' @title Return (Sorted) Table
#' @description
#' Same as \code{table(}) from R, but faster (Rcpp) sorted and with the option
#' to exclude \code{NA} counts.
#' @param x Vector to create table of counts
#' @param decr Decreased order if \code{TRUE}.
#' @param na Include \code{NA} if \code{TRUE}.
#' @return
#' Named integer Vector \code{n}.
#' @import Rcpp
#' @export sortable
sortable <- function(x, decr = TRUE, na = TRUE) {
    .Call('miscset_sortable', PACKAGE = 'miscset', x, decr, na)
}

