% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misclassGLM.R
\name{boot.misclassGLM}
\alias{boot.misclassGLM}
\title{Compute Bootstrapped Standard Errors for \code{misclassGLM} Fits}
\usage{
boot.misclassGLM(ret, Y, X, Pmodel, PX, boot.fraction = 1, repetitions = 1000)
}
\arguments{
\item{ret}{a fitted object of class inheriting from 'misclassGLM'.}

\item{Y}{a vector of integers or numerics. This is the dependent variable.}

\item{X}{a matrix containing the independent variables.}

\item{Pmodel}{a fitted model (e.g. of class 'GLM' or 'mlogit') to implicitly produce variations
of the predicted true values probabilities. (Usually conditional on the observed
misclassified values and additional covariates.)}

\item{PX}{covariates matrix suitable for predicting probabilities from \code{Pmodel},
usually including the mismeasured covariate.}

\item{boot.fraction}{fraction of sample to be used for estimating the bootstrapped standard
errors, for speedup.}

\item{repetitions}{number of bootstrap samples to be drown.}
}
\description{
Obtain bootstrapped standard errors.
}
\seealso{
\code{\link{misclassGLM}}
}
