% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly2dich.R
\name{poly2dich}
\alias{poly2dich}
\title{Change polytomous items to dichotomous item format}
\usage{
poly2dich(data, which.items = 1:ncol(data))
}
\arguments{
\item{data}{an object of class \code{data.frame} or \code{matrix}}

\item{which.items}{a vector indicating which items should be transformed into the
dichotomous form. Default uses all input items}
}
\value{
Returns an integer matrix
}
\description{
Tranforms a matrix of items into a new matrix where the select polytomous items have been
converted into comperable dichotomous items with the same information.
}
\examples{

\dontrun{
data(Science)

head(Science)
newScience <- poly2dich(Science)
head(newScience)

newScience2 <- poly2dich(Science, which.items = 2)
head(newScience2)

}

}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{data}

