% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactants.R
\name{reactants}
\alias{reactants}
\title{Identify the reactants of a stoichometric reaction}
\usage{
reactants(reactionList)
}
\arguments{
\item{reactionList}{A set of stoichiometric reaction with the following characteristics: \itemize{
\item Arrows symbols must be given in the form \code{'=>'} or \code{'<=>'}
\item Inverse arrow symbols \code{'<='} or other types as: \code{'-->'}, \code{'<==>'}, \code{'->'} will not be parsed and will lead to errors.
\item Arrow symbols and plus signs (\code{+}) must be surrounded by a space character
\item Stoichiometric coefficients must be surrounded by a space character and not by parentheses.
\item Each metabolite must have only one stoichiometric coefficient, substituents must be joined to metabolite name by a hyphen (\code{-}) symbol.
\item Exchange reactions have only one metabolite before arrow symbol
\item Compartments must be given between square brackets ([compartment]) joined at the end of metabolite name
}
Some examples of valid stoichiometric reactions are: \itemize{
\item \code{H2O[c] + Urea-1-Carboxylate[c] <=> 2 CO2[c] + 2 NH3[c]}
\item \code{ADP[c] + Phosphoenolpyruvate[c] => ATP[c] + Pyruvate[c]}
\item \code{CO2[c] <=> }
}}
}
\value{
A vector with the identified reactants in the reaction, or a list with the identified reactats in each reaction if a set of stoichiometric reactions was given.
}
\description{
This function identifies the reactants for a set of stoichometric reactions.
}
\author{
Daniel Camilo Osorio <dcosorioh@tamu.edu>
}
