% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabolites.R
\name{metabolites}
\alias{metabolites}
\title{Identify the list of metabolites for a set of stoichiometric reactions}
\usage{
metabolites(reactionList, woCompartment = FALSE, uniques = TRUE)
}
\arguments{
\item{reactionList}{A set of stoichiometric reaction with the following characteristics: \itemize{
\item Arrows symbols must be given in the form \code{'=>'} or \code{'<=>'}
\item Inverse arrow symbols \code{'<='} or other types as: \code{'-->'}, \code{'<==>'}, \code{'->'} will not be parsed and will lead to errors.
\item Arrow symbols and plus signs (\code{+}) must be surrounded by a space character
\item Stoichiometric coefficients must be surrounded by a space character and not by parentheses.
\item Each metabolite must have only one stoichiometric coefficient, substituents must be joined to metabolite name by a hyphen (\code{-}) symbol.
\item Exchange reactions have only one metabolite before arrow symbol
\item Compartments must be given between square brackets ([compartment]) joined at the end of metabolite name
}
Some examples of valid stoichiometric reactions are: \itemize{
\item \code{H2O[c] + Urea-1-Carboxylate[c] <=> 2 CO2[c] + 2 NH3[c]}
\item \code{ADP[c] + Phosphoenolpyruvate[c] => ATP[c] + Pyruvate[c]}
\item \code{CO2[c] <=> }
}}

\item{woCompartment}{A boolean value \code{'TRUE'} or \code{'FALSE'} to indicate if compartment label should be removed}

\item{uniques}{A boolean value \code{'TRUE'} or \code{'FALSE'} to indicate if uniques must be returned}
}
\value{
A list of metabolites for a set of stoichiometric reactions
}
\description{
This function identifies the list of metabolites for a set of stoichiometric reactions. If \code{'woCompartment'} is \code{'TRUE'} compartment label is removed. If \code{'uniques'} is \code{'TRUE'}, list of uniques is returned.
}
\examples{
# Extract metabolites of a stoichiometric reaction
metabolites(reactionList = "ADP[c] + Phosphoenolpyruvate[c] => ATP[c] + Pyruvate[c]")

# Loading a set of stoichiometric reactions
glycolysis <- read.csv(system.file("extdata/glycolysisModel.csv",package = "minval"), sep='\\t')

# Extract unique metabolites
metabolites(reactionList = glycolysis$REACTION)

#' # Extract unique metabolites without compartments
metabolites(reactionList = glycolysis$REACTION, woCompartment = TRUE)

# Extract all metabolites
metabolites(reactionList = glycolysis$REACTION, uniques = FALSE)
}
\author{
Daniel Camilo Osorio <dcosorioh@tamu.edu>
}
