% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orphanMetabolites.R
\name{orphanMetabolites}
\alias{orphanMetabolites}
\alias{orphanReactants}
\alias{orphanProducts}
\title{Identify the orphan metabolites of a set of stoichiometric reactions}
\usage{
orphanMetabolites(reactionList, actingAs = NULL, byCompartment = FALSE)

orphanReactants(reactionList, byCompartment = FALSE)

orphanProducts(reactionList, byCompartment = FALSE)
}
\arguments{
\item{reactionList}{A set of stoichiometric reaction with the following characteristics: \itemize{
\item Arrows symbols must be given in the form \code{'=>'} or \code{'<=>'}
\item Inverse arrow symbols \code{'<='} or other types as: \code{'-->'}, \code{'<==>'}, \code{'->'} will not be parsed and will lead to errors.
\item Arrow symbols and plus signs (\code{+}) must be surrounded by a space character
\item Stoichiometric coefficients must be surrounded by a space character and not by parentheses.
\item Each metabolite must have only one stoichiometric coefficient, substituents must be joined to metabolite name by a hyphen (\code{-}) symbol.
\item Exchange reactions have only one metabolite before arrow symbol
\item Compartments must be given between square brackets ([compartment]) joined at the end of metabolite name
}
Some examples of valid stoichiometric reactions are: \itemize{
\item \code{H2O[c] + Urea-1-Carboxylate[c] <=> 2 CO2[c] + 2 NH3[c]}
\item \code{ADP[c] + Phosphoenolpyruvate[c] => ATP[c] + Pyruvate[c]}
\item \code{CO2[c] <=> }
}}

\item{actingAs}{A text string that specifies the type of metabolite to be returned; only \code{'reactant'} and \code{'product'} are supported.}

\item{byCompartment}{A boolean value \code{'TRUE'} or \code{'FALSE'} to indicate if orphan reactants should be reported by compartment}
}
\value{
If \code{byCompartment == FALSE}, a vector with orphan reactants is returned, in opposite case a list is returned.
If \code{actingAs == 'reactant'}, metabolites not produced in any other reaction or just are involved in one reaction are returned.
If \code{actingAs == 'products'}, metabolites not consumed in any other reaction or just are involved in one reaction are returned.
}
\description{
This function identifies the orphan metabolites (metabolites not produced or not consumed in any other reaction or just involved in one reaction) for a set of stoichometric reactions.
}
\section{Functions}{
\itemize{
\item \code{orphanReactants}: Identify the orphan reactants of a set of stoichometric reactions

\item \code{orphanProducts}: Identify the orphan products of a set of stoichometric reactions
}}

\examples{
# Loading a set of stoichiometric reactions
glycolysis <- read.csv(system.file("extdata/glycolysisModel.csv",package = "minval"), sep="\\t")

# Identify orphan metabolites
orphanMetabolites(reactionList = glycolysis$REACTION)

# Identify orphan reactants
orphanReactants(reactionList = glycolysis$REACTION)

# Identify orphan products
orphanProducts(reactionList = glycolysis$REACTION)

# Identify orphan metabolites by compartment
orphanMetabolites(reactionList = glycolysis$REACTION, byCompartment = TRUE)
}
\author{
Daniel Camilo Osorio <dcosorioh@unal.edu.co>
}
