% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_sql.R
\name{mc_sql}
\alias{mc_sql}
\title{Use the S3 variant of SQL to query a minio object}
\usage{
mc_sql(
  target,
  query = "select * from S3Object",
  recursive = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{target}{character alias or path specification at minio for
the object (a .csv, .json or .parquet file)}

\item{query}{character string with sql query, by default "select * from S3Object"}

\item{recursive}{logical, by default TRUE, allowing a s3 select query to work
across a minio ALIAS/PATH specification}

\item{verbose}{logical, by default FALSE}
}
\description{
The S3 Select API can be used against CSV and JSON objects stored in minio.
If the minio server runs with MINIO_API_SELECT_PARQUET=on, also parquet files
can be queried.
}
\details{
See \url{https://min.io/docs/minio/linux/reference/minio-mc/mc-sql.html#} and
\url{https://github.com/minio/minio/blob/master/docs/select/README.md}

For example "select s.* from S3Object s limit 10" is valid syntax.

More examples of query syntax here:
\url{https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-select-sql-reference-select.html}
}
\examples{
\dontrun{
# upload a CSV file
tf <- tempfile()
write.csv(iris, tf, row.names = FALSE)
mc_mb("play/iris")
mc_cp(tf, "play/iris/iris.csv")

# read first 12 lines from the CSV
mc_sql("play/iris/iris.csv", query = "select * from S3Object limit 12")
}#' 
}
