% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_anonymous.R
\name{mc_anonymous_set}
\alias{mc_anonymous_set}
\alias{mc_policy_set}
\title{Set anonymous access policy}
\usage{
mc_anonymous_set(target, policy = c("download", "upload", "public", "private"))
}
\arguments{
\item{target}{Character string specifying the target cloud storage
bucket or object}

\item{policy}{Character string specifying the anonymous access policy.
Must be one of "download", "upload", "public" (upload and download),
or "private".}
}
\value{
Returns the list from \code{\link[processx:run]{processx::run()}}, with components \code{status},
\code{stdout}, \code{stderr}, and \code{timeout}; invisibly.
}
\description{
This function uses the \code{mc} command to set the anonymous access policy for
a specified target.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# create a test bucket on the 'play' server
mc_mb("play/minioclient-test")

# Set anonymous access policy to download
mc_anonymous_set("play/minioclient-test/file.txt", policy = "download")

# Set anonymous access policy to upload
mc_anonymous_set("play/minioclient-test/directory", policy = "upload")

# Set anonymous access policy to public
mc_anonymous_set("play/minioclient-test/file.txt", policy = "public")

# Set anonymous access policy to private (default policy for new buckets)
mc_anonymous_set("play/minioclient-test/directory", policy = "private")

mc_rb("play/minioclient-test")
\dontshow{\}) # examplesIf}
}
