% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysisOptions.R
\name{analysisOptions}
\alias{analysisOptions}
\title{Get analytical options from miniMeta object}
\usage{
analysisOptions(x, data = FALSE)
}
\arguments{
\item{x}{An object of class \code{miniMeta}}

\item{data}{If \code{TRUE}, the data associated with the meta-analysis
are included in the return value. This allows you for example to run:
\code{do.call(metabin, analysisOptions(x, data=TRUE))} or
\code{do.call(metagen, analysisOptions(x, data=TRUE))} 
(depending on the contents of x), in order to re-run the meta-analysis.}
}
\value{
A named list of arguments corresponding to the arguments of 
\code{\link[meta]{metagen}} or \code{\link[meta]{metabin}}.
}
\description{
This function returns the analytical options stored in a miniMeta object,
as a named list of arguments, for further processing.
}
\examples{
\donttest{
analysisOptions(example_miniMeta_rct)
}

}
