% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mine_onemeasure.R
\name{mine_stat}
\alias{mine_stat}
\alias{MIC}
\alias{mic}
\alias{MAS}
\alias{mas}
\alias{MEV}
\alias{mev}
\alias{MCN}
\alias{mcn}
\alias{GMIC}
\alias{gmic}
\alias{TIC}
\alias{tic}
\title{Function to compute one measure at time}
\usage{
mine_stat(x, y, alpha = 0.6, C = 15, est = "mic_approx",
  measure = "mic", eps = NULL, p = -1, norm = FALSE)
}
\arguments{
\item{x}{a numeric vector (of size \emph{n}), matrix or data frame (which is coerced to matrix).}

\item{y}{NULL (default) or a numeric vector of size \emph{n} (\emph{i.e.}, with compatible dimensions to x).}

\item{alpha}{an optional number of cells allowed in the \emph{X-by-Y} search-grid. Default value is 0.6 (see Details).}

\item{C}{an optional number determining the starting point of the 
\emph{X-by-Y} search-grid. When trying to partition the \emph{x}-axis into 
\emph{X} columns, the algorithm will start with at most \code{C}\emph{X} 
\emph{clumps}. Default value is 15 (see Details).}

\item{est}{Default value is "mic_approx". With est="mic_approx" the original MINE statistics will
be computed, with est="mic_e" the equicharacteristic matrix is
is evaluated and the mic() and tic() methods will return MIC_e and
TIC_e values respectively.}

\item{measure}{character indicating the measure to extract. Default value "mic". 
Availiable values are: "mic", "mas", "mev", "mcn", "tic", "gmic".}

\item{eps}{integer in [0,1].  If 'NULL' (default) it is set to
1-MIC. It can be set to zero for noiseless functions,
but the default choice is the most appropriate parametrization
for general cases (as stated in Reshef et al. SOM).
It provides robustness.}

\item{p}{probability for the generalized `mic`}

\item{norm}{boolean if require normalization between 0 and 1 for the `tic` statistic}
}
\description{
Function to compute one measure at time
}
\examples{
x <- runif(10); y <- 3*x+2;
mine_stat(x,y, measure="mic")
}
