# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Function to compute one statistic at time
#' 
#' @param x Numeric Vector
#' @param y Numeric Vector
#' @param alpha alpha parameter for the mine statistic
#' @param C c parameter for the mine statistic
#' @param est estimation parameter for the mine statistic
#' @param measure character which measure to return
#' @param eps eps value for MCN statistic
#' @param p probability for the generalized mic
#' @param norm boolean if require normalization between 0 and 1 for the tic statistic
#' @export
mine_compute <- function(x, y, alpha = 0.6, C = 15, est = "mic_approx", measure = 1L, eps = 0.0, p = -1, norm = FALSE) {
    .Call('_minerva_mine_compute', PACKAGE = 'minerva', x, y, alpha, C, est, measure, eps, p, norm)
}

#' Compute pairwise statistics (MIC and normalized TIC) between variables
#' (convenience function).
#'
#' For each statistic, the upper triangle of the matrix is stored by row
#' (condensed matrix). If m is the number of variables, then for i < j < m, the
#' statistic between (col) i and j is stored in k = m*i - i*(i+1)/2 - i - 1 + j.
#' The length of the vectors is n = m*(m-1)/2.
#' @param x Numeric matrix of m-by-n of n variables and m samples
#' @param alpha alpha parameter for the mine statistic
#' @param C c parameter for the mine statistic
#' @param est estimation parameter for the mine statistic
#' 
#' @return
#' Matrix (n x (n-1)/2) by 4. The first and second column indicate the indexes relative of the columns 
#' in the inut matrix the statistic is computed for.
#' Column 3 contains the MIC statistic, while column 4 contains the normalized TIC statistic.
#' @export
mine_compute_pstats <- function(x, alpha = 0.6, C = 15, est = "mic_approx") {
    .Call('_minerva_mine_compute_pstats', PACKAGE = 'minerva', x, alpha, C, est)
}

#'Compute statistics (MIC and normalized TIC) between each pair of the two
#' collections of variables (convenience function).
#' If n and m are the number of variables in X and Y respectively, then the
#'   statistic between the (row) i (for X) and j (for Y) is stored in mic[i, j]
#' and tic[i, j].
#'  
#' @param x Numeric Matrix of m-by-n with n variables and m samples.
#' @param y Numeric Matrix of m-by-p with p variables and m samples.
#' @param alpha float (0, 1.0] or >=4 if alpha is in (0,1] then B will be max(n^alpha, 4) where n is the
#' number of samples. If alpha is >=4 then alpha defines directly the B
#' parameter. If alpha is higher than the number of samples (n) it will be
#' limited to be n, so B = min(alpha, n).
#' @param C float (> 0) determines how many more clumps there will be than columns in
#' every partition. Default value is 15, meaning that when trying to
#' draw x grid lines on the x-axis, the algorithm will start with at
#' most 15*x clumps.
#' @param est string ("mic_approx", "mic_e") estimator. 
#' With est="mic_approx" the original MINE statistics will
#' be computed, with est="mic_e" the equicharacteristic matrix is
#' is evaluated and MIC_e and TIC_e are returned.
#' 
#' @return list of two elements:
#' MIC: the MIC statistic matrix (n x p).
#' TIC: the normalized TIC statistic matrix (n x p).
#' @export
mine_compute_cstats <- function(x, y, alpha = 0.6, C = 15, est = "mic_approx") {
    .Call('_minerva_mine_compute_cstats', PACKAGE = 'minerva', x, y, alpha, C, est)
}

