# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Processing RBC for a person.
#' 
#' This function is used to resolve one person's journeys, i.e., classifying 
#' a person and marking it whether or not to be a long term migrant based on 
#' the person's journeys. This function is used internally 
#' inside the package and shouldn't be exposed to the outside caller.
#' 
#' @param person_data A list object of a person's journeys.
#' @param int_res_status The initial residence status of the target person
#' @param initial_date_finalised The final resolved date of the initial residence
#'  status.
#' @param tw Windows Size, by default, it is 487 days.
#' @param tm Threshold of Year, by default, it is 365 days.
#' 
#' @return A list of classified / labelled journeys.
#' 
rcpp_resolve <- function(person_data, int_res_status, initial_date_finalised, tw, tm) {
    .Call(`_migrbc_rcpp_resolve`, person_data, int_res_status, initial_date_finalised, tw, tm)
}

#' Processing RBC for a list of person.
#' 
#' This function is used to resolve a list of person's journeys,
#' i.e., classifying a list of people and marking it whether or not 
#' to be a long term migrant based on the person's journeys. 
#' This function is used internally inside the package and shouldn't 
#' be exposed to the outside caller.
#' 
#' @param cross_data The personal crossing data for RBC process
#' @param ini_status_data the initial residence status data
#' @param tw Windows Size, by default, it is 487 days.
#' @param ty Threshold of Year, by default, it is 365 days.
#' 
#' @return A data frame object of classified / labelled journeys
#' 
run_rbc_process_core <- function(cross_data, ini_status_data, tw, ty) {
    .Call(`_migrbc_run_rbc_process_core`, cross_data, ini_status_data, tw, ty)
}

#' Processing RBC for a list of person.
#' 
#' This function is used to resolve a list of person's journeys with error,
#' This function is used internally inside the package and shouldn't 
#' be exposed to the outside caller.
#' 
#' @param cross_data The personal crossing data for RBC process
#' @param ini_status_data the initial residence status data
#' @param error_message The error message.
#' @param tw Windows Size, by default, it is 487 days.
#' 
#' @return A data frame object of classified / labelled journeys
#' 
run_rbc_process_with_error <- function(cross_data, ini_status_data, error_message, tw) {
    .Call(`_migrbc_run_rbc_process_with_error`, cross_data, ini_status_data, error_message, tw)
}

