% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{diversity}
\alias{diversity}
\alias{graph_blau_index}
\alias{graph_ei_index}
\title{Measures of network diversity}
\usage{
graph_blau_index(object, attribute, clusters = NULL)

graph_ei_index(object, attribute)
}
\arguments{
\item{object}{A data frame edgelist, matrix, igraph, tidygraph, or
network object.}

\item{attribute}{The name of a vertex attribute to measure the diversity of.}

\item{clusters}{A nodal cluster membership vector or name of a vertex attribute.}
}
\description{
These functions offer ways to summarise the heterogeneity of an attribute
across a network, within groups of a network, or the distribution of ties
across this attribute.
}
\examples{
marvel_friends <- to_unsigned(ison_marvel_relationships, "positive")
graph_blau_index(marvel_friends, "Gender")
graph_blau_index(marvel_friends, "Attractive")
graph_blau_index(marvel_friends, "Gender", "Rich")
graph_ei_index(marvel_friends, "Gender")
graph_ei_index(marvel_friends, "Attractive")
}
