% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz_autographr.R
\name{auto_graph}
\alias{auto_graph}
\alias{autographr}
\alias{autographs}
\title{Quickly graph networks with sensible defaults}
\usage{
autographr(
  object,
  layout = "stress",
  labels = TRUE,
  node_color = NULL,
  node_group = NULL,
  node_shape = NULL,
  node_size = NULL,
  edge_color = NULL,
  ...
)

autographs(netlist, ...)
}
\arguments{
\item{object}{A migraph-consistent object.}

\item{layout}{An igraph layout algorithm,
currently defaults to 'stress'.}

\item{labels}{Logical, whether to print node names
as labels if present.}

\item{node_color}{Node variable in quotation marks to be used for
coloring the nodes. It is easiest if this is added as a node attribute to
the graph before plotting.}

\item{node_group}{Node variable in quotation marks to be used for
drawing convex but also concave hulls around clusters of nodes.
These groupings will be labelled with the categories of the variable passed.}

\item{node_shape}{Character string in quotation marks referring to the name
of a node attribute already present in the graph to be used for the shapes
of the nodes.
Shapes follow the ordering "circle", "square", "triangle",
so this aesthetic should be used for a variable with only a few categories.}

\item{node_size}{Node variable in quotation marks to be used for
the size of the nodes.
This can be any continuous variable on the nodes of the network.
Since this function expects this to be an existing variable,
it is recommended to calculate all node-related statistics prior
to using this function.}

\item{edge_color}{Tie variable in quotation marks to be used for
coloring the nodes. It is easiest if this is added as an edge or tie attribute
to the graph before plotting.}

\item{...}{Extra arguments to pass on to \code{autographr()}/\code{ggraph()}/\code{ggplot()}.}

\item{netlist}{A list of migraph-compatible networks.}
}
\description{
The aim of this function is to provide users with a quick and easy
graphing function that makes best use of the data,
whatever its composition. Users can also tailor the plot according to their
preferences regarding node size, colour, and shape. The function also supports
visualisation of network measures such as centrality.
}
\section{Functions}{
\itemize{
\item \code{autographr()}: Graphs a network with sensible defaults

\item \code{autographs()}: Graphs a list of networks
with sensible defaults

}}
\examples{
ison_adolescents \%>\% 
  mutate(shape = rep(c("circle", "square"), times = 4)) \%>\%
  mutate(color = rep(c("blue", "red"), times = 4)) \%>\% 
  autographr(node_shape = "shape", node_color = "color")
autographr(ison_karateka, node_size = 8)
ison_adolescents \%>\% 
  mutate(high_degree = node_is_max(node_degree())) \%>\% 
  activate(edges) \%>\% 
  mutate(high_betweenness = tie_is_max(tie_betweenness(ison_adolescents))) \%>\% 
  autographr(node_color = "high_degree", edge_color = "high_betweenness")
autographr(mpn_elite_usa_advice, "concentric")
autographs(to_egos(ison_adolescents))
}
\seealso{
Other mapping: 
\code{\link{grid_layouts}},
\code{\link{partition_layouts}}
}
\concept{mapping}
