% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/death_mat.R
\name{death_mat}
\alias{death_mat}
\title{Calculate deaths for each element of place of birth - place of residence stock matrix}
\usage{
death_mat(
  d_por = NULL,
  m1 = NULL,
  method = "proportion",
  m2 = NULL,
  b_por = NULL
)
}
\arguments{
\item{d_por}{Vector of numeric values for deaths in each place of residence.}

\item{m1}{Matrix of migrant stock totals at time \emph{t}+1. Rows in the matrix correspond to place of birth and columns to place of residence at time \emph{t}+1. Used to distribute deaths proportionally to each migrant stock population. For use when \code{method = "accounting"}}

\item{method}{Character string of either \code{"proportion"} or \code{"accounting"} to choose method to distrubte deaths. The \code{"proportion"} method assumes the mortality rate in each place of birth sub-group (native born and all foreign born stocks) is the same. The \code{"accounting"} method ensures that the the deaths by place of birth matches that implied by demographic accounting. Still needs to be explored fully.}

\item{m2}{Matrix of migrant stock totals at time \emph{t}+1. Rows in the matrix correspond to place of birth and columns to place of residence at time \emph{t}+1. Used to distribute deaths proportionally to each migrant stock population.}

\item{b_por}{Vector of numeric values for births in each place of residence. For use when \code{method = "accounting"}.}
}
\value{
Matrix of place of death by place of residence
}
\description{
This function is predominantly intended to be used within the \code{ffs} routines in the migest package.
}
\seealso{
\code{\link{ffs_diff}}
}
\author{
Guy J. Abel
}
