% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_sum.R
\name{block_sum}
\alias{block_sum}
\title{Sum over a selected block in a block matrix}
\usage{
block_sum(block = NULL, m = NULL, block_id = NULL)
}
\arguments{
\item{block}{Numeric value of block to summed. To be matched against the matrix in \code{block_id}.}

\item{m}{Matrix of all blocks combined.}

\item{block_id}{Matrix of the same dimensions of \code{m} used to identify blocks.}
}
\value{
Returns a numeric value of the sum of a single block.
}
\description{
Returns of a sum of a block within a \code{matrix}. This function is predominantly intended to be used within the \code{\link{ipf2_block}} routine.
}
\examples{
m <- matrix(data = 100:220, nrow = 11, ncol = 11)
b <- block_matrix(x = 1:16, b = c(2, 3, 4, 2))
block_sum(block = 1, m = m, block_id = b)
block_sum(block = 4, m = m, block_id = b)
block_sum(block = 16, m = m, block_id = b)
}
\seealso{
\code{\link{block_matrix}}, \code{\link{stripe_matrix}}, \code{\link{ipf2_block}}
}
\author{
Guy J. Abel
}
