% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{toy_term}
\alias{toy_term}
\title{Term data for examples}
\format{
\code{data.table} with 150 rows and 5 columns keyed by student ID.

\describe{

\item{\code{mcid}}{Character, de-identified student ID.}

\item{\code{institution}}{Character, de-identified institution name, e.g.,
Institution A, Institution B, etc.}

\item{\code{term}}{Character, academic year and term, format YYYYT.}

\item{\code{cip6}}{Character, 6-digit CIP code of program in which a student
is enrolled in a term.}

\item{\code{level}}{Character, 01 Freshman, 02 Sophomore, etc. The equivalent
values in the current practice data are 01 First-Year, 02-Second Year,
etc.}

}
}
\usage{
toy_term
}
\description{
Selected variables modeled on those in the \code{term} practice data for use in
package examples and articles. Sampled from an early version of the practice
data, the toy data are not a current practice data sample.
}
\seealso{
Other toy-data: 
\code{\link{toy_course}},
\code{\link{toy_degree}},
\code{\link{toy_student}}
}
\concept{toy-data}
\keyword{datasets}
