% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thetafit.R
\name{thetafit}
\alias{thetafit}
\title{Nodewise LASSO regressions to fit the precision matrix \ifelse{html}{\out{&Theta;}}{\eqn{\Theta}}.}
\usage{
thetafit(x, parallel = FALSE, ncores = getOption("mc.cores", NULL), 
         intercept = FALSE, K = 20, l = 5, seed = NULL, verbose = FALSE, 
         registerpar = TRUE, ...)
}
\arguments{
\item{x}{T by p data matrix, where T and p respectively denote the sample size and the number of regressors.}

\item{parallel}{if \code{TRUE}, use parallel foreach to fit nodewise LASSO regressions. Parallel registered within the function.}

\item{ncores}{number of cores used in parallelization}

\item{intercept}{whether intercept be fitted (\code{TRUE}) or set to zero (\code{FALSE}). Default is \code{FALSE}.}

\item{K}{number of folds of the cv loop. Default set to \code{20}.}

\item{l}{the gap used to drop observations round test set data. See \link{tscv.sglfit} for more details.}

\item{seed}{set a value for seed to control results replication, i.e. \code{set.seed(seed)} is used. \code{seed} is stored in the output list. Default set to \code{as.numeric(Sys.Date())}.}

\item{verbose}{if \code{TRUE}, prints progress bar. Default set to \code{FALSE}.}

\item{registerpar}{if \code{TRUE}, register parallelization using \code{registerDoParallel}. Default set to \code{TRUE}.}

\item{...}{Other arguments that can be passed to \link{tscv.sglfit}.}
}
\value{
thetafit object.
}
\description{
Fits the precision matrix \ifelse{html}{\out{&Theta;}}{\eqn{\Theta}} by running nodewise LASSO regressions.
}
\details{
The function runs \link{tscv.sglfit} \code{p} times by regressing \code{j}-th covariate on all other covariates excluding \code{j}-th covariate. The precision matrix is then constructed based on LASSO estimates. Each nodewise LASSO regression tuning parameter \ifelse{html}{\out{&lambda;}}{\eqn{\lambda}} is optimized using time series cross-validation. See \link{tscv.sglfit} for more details on cross-validation implementation.
}
\examples{
set.seed(1)
x = matrix(rnorm(100 * 20), 100, 20)
thetafit(x = x, parallel = FALSE)
}
\author{
Jonas Striaukas
}
