% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{select_coef}
\alias{select_coef}
\title{select a subset of coefficients}
\usage{
select_coef(object, subset = NA, fixed = FALSE, grep = NULL, invert = FALSE)
}
\arguments{
\item{object}{a fitted model}

\item{subset}{a character vector, the type of parameters to extract}

\item{fixed}{if \code{TRUE}, the fixed parameters are selected}

\item{grep}{a regular expression}

\item{invert}{should the coefficients that \strong{don't} match the
pattern should be selected ?}
}
\value{
a numeric vector
}
\description{
\code{micsr} objects have a \code{rpar} element which is vector of integers
with names that indicates the kind of the coefficients. For
example, if the 6 first coefficients are covariates parameters and
the next 3 parameters that define the distribution of the errors,
\code{npar} will be c(covariates = 6, vcov = 3). It has an attribute
which indicates the subset of coefficients that should be selected
by default. \code{select_coef} has a \code{subset} argument (a character
vector) and returns a vector of integers which is the position of
the coefficients to extract.
}
