% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multialign.R
\name{msalign}
\alias{msalign}
\title{Multiple alignment}
\usage{
msalign(fdata, machine = "muscle")
}
\arguments{
\item{fdata}{A \code{Fasta} object with input sequences.}

\item{machine}{Function that does the 'dirty work'.}
}
\value{
Results are returned as a \code{Fasta} object.
}
\description{
Quickly computing a smallish multiple sequence alignment.
}
\details{
This function computes a multiple sequence alignment given a set of sequences in a \code{Fasta} object,
see \code{\link{readFasta}} for more on \code{Fasta} objects.

It is merely a wrapper for the function named in \code{machine} to avoid explicit writing and reading of files.
This function should only be used for small data sets, since no result files are stored. For heavier jobs,
use the \code{machine} function directly.

At present, the only \code{machine} function implemented is \code{\link{muscle}}, but other third-party \code{machine}s 
may be included later.

Note that this function will run \code{\link{muscle}} with default settings, which is fine for small data sets.
}
\examples{
\dontrun{
ex.file <- file.path(file.path(path.package("microseq"),"extdata"),"small.fasta")
fdta <- readFasta(ex.file)
msa <- msalign(fdta)
}

}
\author{
Lars Snipen.
}
\seealso{
\code{\link{muscle}}, \code{\link{msaTrim}}.
}

