% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdist.R
\name{bDist}
\alias{bDist}
\title{Computes distances between sequences based on BLAST results}
\usage{
bDist(blast.files, e.value = 1, verbose = TRUE)
}
\arguments{
\item{blast.files}{A text vector of filenames.}

\item{e.value}{A threshold E-value to immediately discard (very) poor BLAST alignments.}

\item{verbose}{Logical, indicating if textual output should be given to monitor the progress.}
}
\value{
The function returns a \samp{tibble} with columns \samp{Query}, \samp{Hit}, \samp{Bitscore}
and \samp{Distance}. Each row corresponds to a pair of sequences having at least one BLAST hit between
them. All pairs \emph{not} listed in the output have distance 1.0 between them.
}
\description{
Reads a complete set of result files from a BLAST search and
computes distance between all sequences based on the BLAST bit-score.
}
\details{
Each input file must be a BLAST result file produced by \code{\link{blastpAllAll}}.

Setting a small \samp{e.value} threshold can speed up the computation and reduce the size of the
output, but you may loose some alignments that could produce smallish distances for short sequences.

The distance computed is based on alignment bitscores. Assume the alignment of query A against hit B
has a bitscore of S(A,B). Then, we also typically find an alignment of query B against hit A with
bitscore S(B,A). The maximum of these two are used as the bitscore for this pair, and in virtually
all cases S(A,B)=S(B,A) anyway. The distance is D(A,B)=1-2*S(A,B)/(S(A,A)+S(B,B)) where S(A,A) (or S(B,B))
is the bitscore of aligning A (or B) against itself. A distance of
0.0 means A and B are identical. The maximum possible distance is 1.0, meaning there is no BLAST hit
found either way.

This distance should not be interpreted as lack of identity! A distance of 0.0 means 100\% identity,
but a distance of 0.25 does \emph{not} mean 75\% identity. It has some resemblance to an evolutinary
(raw) distance, but since it is based on protein alignments, the type of mutations plays a significant
role, not only the number of mutations.
}
\examples{
# Using BLAST result files in this package...
prefix <- c("GID1_vs_GID1_",
            "GID2_vs_GID1_",
            "GID3_vs_GID1_",
            "GID2_vs_GID2_",
            "GID3_vs_GID2_",
            "GID3_vs_GID3_")
bf <- file.path(path.package("micropan"), "extdata", str_c(prefix, ".txt.xz"))

# We need to uncompress them first...
blast.files <- tempfile(pattern = prefix, fileext = ".txt.xz")
ok <- file.copy(from = bf, to = blast.files)
blast.files <- unlist(lapply(blast.files, xzuncompress))

# Computing pairwise distances
blast.dist <- bDist(blast.files)

# ...and cleaning...
ok <- file.remove(blast.files)

# See also example for blastpAllAll

}
\seealso{
\code{\link{blastpAllAll}}, \code{\link{bClust}}, \code{\link{isOrtholog}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
