% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polymorphism.R
\name{get_snp}
\alias{get_snp}
\title{Get SNPs from a data frame}
\usage{
get_snp(df, row = NULL, top = NULL, col.snp = SNPs, col.pmid = PMID)
}
\arguments{
\item{df}{Data frame containing SNPs. If \code{top} is set, \code{df} must also
contain PubMed IDs.}

\item{row}{Integer. Optional. Specifies row from which SNP shall be obtained. Works best
with a data frame listing counts only as from \code{\link[=count_snp]{count_snp()}}.
If neither \code{row} nor \code{top} is given, \code{row} is automatically set to \code{1}.}

\item{top}{Integer. Optional. Specifies number of most frequent SNPs to return.}

\item{col.snp}{Symbol. Column containing SNPs.}

\item{col.pmid}{Symbol. Column containing PubMed IDs. Necessary if the data
frame provided is not a count data frame.}
}
\value{
String or character vector containing SNPs.
}
\description{
Get SNPs from a data frame.
}
\details{
Get SNPs from a data frame.
\itemize{
\item If a data frame containing SNP counts as from \code{\link[=count_snp]{count_snp()}} is provided,
these SNPs are specified by the row they are listed in. To get the SNPs by
row, set the \code{row} argument.
\item If a data frame with PubMed IDs is provided, these SNPs are specified by
their top occurrence. To get the SNPs by frequency, set the \code{top} argument.
}

If neither \code{row} nor \code{top} is provided, \code{row} is automatically set to \code{1}.
}
\seealso{
\code{\link[=extract_snp]{extract_snp()}},
\code{\link[=count_snp]{count_snp()}},
\code{\link[=subset_snp]{subset_snp()}}

Other get functions: 
\code{\link{get_distinct_mir_df}()},
\code{\link{get_distinct_mir_vec}()},
\code{\link{get_mir}()},
\code{\link{get_pmid}()},
\code{\link{get_shared_mir_df}()},
\code{\link{get_shared_mir_vec}()}
}
\concept{get functions}
