% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinct_shared_mir.R
\name{get_distinct_mir_vec}
\alias{get_distinct_mir_vec}
\title{Identify miRNA names distinct for one vector compared to another vector}
\usage{
get_distinct_mir_vec(mirna.vec.1, mirna.vec.2)
}
\arguments{
\item{mirna.vec.1}{Character vector. First vector containing miRNA
names.}

\item{mirna.vec.2}{Character vector. Second vector containing miRNA
names.}
}
\value{
Character vector containing miRNA names distinct for \code{mirna.vec.1}
compared to \code{mirna.vec.2}.
}
\description{
Identify miRNA names distinct for one vector compared to another vector.
}
\details{
Get distinct miRNA names of one vector compared to another vector.
\code{get_distinct_mir()} compares two vectors containing miRNA names and
returns the miRNA names that are exclusive for \code{mirna.vec.1}.
}
\seealso{
Other get functions: 
\code{\link{get_distinct_mir_df}()},
\code{\link{get_mir}()},
\code{\link{get_pmid}()},
\code{\link{get_shared_mir_df}()},
\code{\link{get_shared_mir_vec}()},
\code{\link{get_snp}()}
}
\concept{get functions}
