% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rubin2bt_one.R
\name{rubin2bt.one}
\alias{rubin2bt.one}
\title{2nd Rubin's rule Between-Imputation Component (a given peptide)}
\usage{
rubin2bt.one(peptide, data, funcmean, metacond)
}
\arguments{
\item{peptide}{peptide for which the variance-covariance matrix should be derived.}

\item{data}{dataset}

\item{funcmean}{function that should be used to compute the mean}

\item{metacond}{a factor to specify the groups}
}
\value{
A variance-covariance matrix.
}
\description{
Computes the between-imputation component in the 2nd Rubin's rule for a given peptide.
}
\examples{
library(mi4p)
data(datasim)
datasim_imp <- multi.impute(data = datasim[,-1], conditions = 
attr(datasim,"metadata")$Condition, method = "MLE")
rubin2bt.one(1,datasim_imp,funcmean = meanImp_emmeans,
attr(datasim,"metadata")$Condition)
}
\references{
M. Chion, Ch. Carapito and F. Bertrand (2021). \emph{Accounting for multiple imputation-induced variability for differential analysis in mass spectrometry-based label-free quantitative proteomics}. arxiv:2108.07086. \url{https://arxiv.org/abs/2108.07086}.
}
\author{
Frédéric Bertrand
}
