% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{Interface}
\alias{Interface}
\title{Interface}
\description{
Interface

Interface
}
\details{
Interface class for interacting with WMS, WFS, and WMTS Streaming classes.

This class provides a unified interface to access the WMS, WFS, and WMTS Streaming classes.

The `search` function performs a search for features within the specified bounding box and/or with a specified filter.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{mgp_sdk}}{(Optional) An instance of the MGP_SDK Python library. If NULL, a new instance will be created. Default is NULL.}

\item{\code{py_interface}}{(Optional) An instance of the Interface class from the MGP_SDK Python library. If NULL, a new instance will be created. Default is NULL.}

\item{\code{env_name}}{= (Optional) The name of the environment where the MGP_SDK Python library is installed. Default is "R-MGP-SDK".}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Interface-new}{\code{Interface$new()}}
\item \href{#method-Interface-search}{\code{Interface$search()}}
\item \href{#method-Interface-download_image}{\code{Interface$download_image()}}
\item \href{#method-Interface-get_full_res_image}{\code{Interface$get_full_res_image()}}
\item \href{#method-Interface-clone}{\code{Interface$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-new"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-new}{}}}
\subsection{Method \code{new()}}{
Initializes the `Interface` object. Sets up the environment for using the MGP_SDK Python library.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$new(mgp_sdk = NULL, py_interface = NULL, env_name = "R-MGP-SDK")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mgp_sdk}}{(Optional) An instance of the MGP_SDK Python library. If NULL, a new instance will be created. Default is NULL.}

\item{\code{py_interface}}{(Optional) An instance of the Interface class from the MGP_SDK Python library. If NULL, a new instance will be created. Default is NULL.}

\item{\code{env_name}}{(Optional) The name of the environment where the MGP_SDK Python library is installed. Default is "R-MGP-SDK".}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-search"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-search}{}}}
\subsection{Method \code{search()}}{
Perform a search for features within the specified bounding box and/or with a specified filter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$search(
  bbox = NULL,
  filter = NULL,
  shapefile = FALSE,
  csv = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bbox}}{A string indicating the bounding box of the area of interest (miny,minx,maxy,maxx).}

\item{\code{filter}}{A string containing a CQL filter used to refine the data of the search. Default is NULL.}

\item{\code{shapefile}}{A logical indicating whether to return a shapefile. Default is FALSE.}

\item{\code{csv}}{A logical indicating whether to return a CSV file. Default is FALSE.}

\item{\code{...}}{Additional arguments to pass to the `search` method.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If `shapefile` is TRUE, the function returns a shapefile of all features and associated metadata.
If `csv` is TRUE, the function returns a CSV file. If neither is specified, the function returns a list of features.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-download_image"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-download_image}{}}}
\subsection{Method \code{download_image()}}{
Download an image from a WMS or WMTS service


This function allows you to download an image from a Web Map Service (WMS) or a


Web Map Tile Service (WMTS). You can specify the bounding box, image dimensions, image


format, and other parameters to customize the downloaded image.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$download_image(
  bbox = NULL,
  srsname = "EPSG:4326",
  height = NULL,
  width = NULL,
  img_format = "jpeg",
  identifier = NULL,
  zoom_level = NULL,
  download = TRUE,
  outputpath = NULL,
  display = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bbox}}{A vector of four numeric values specifying the bounding box of the image.}

\item{\code{srsname}}{A string specifying the spatial reference system (SRS) of the bounding box. Default is "EPSG:4326".}

\item{\code{height}}{The height of the image in pixels.}

\item{\code{width}}{The width of the image in pixels.}

\item{\code{img_format}}{A string specifying the image format. Must be one of "jpeg", "png", or "geotiff".}

\item{\code{identifier}}{A string specifying the identifier of the image.}

\item{\code{zoom_level}}{An integer specifying the zoom level of the WMTS image.}

\item{\code{download}}{A logical value indicating whether to download the image (TRUE) or return the raw image data (FALSE).}

\item{\code{outputpath}}{A string specifying the directory where the downloaded image should be saved.}

\item{\code{display}}{A logical value indicating whether to display the downloaded image (TRUE) or not (FALSE).}

\item{\code{gridoffsets}}{A vector of two numeric values specifying the grid offsets of the image.}

\item{\code{...}}{Additional parameters to be passed to the WMS or WMTS service.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If `download` is TRUE, the function returns the filename of the downloaded image. If `download` is FALSE,
the function returns the raw image data as a binary vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-get_full_res_image"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-get_full_res_image}{}}}
\subsection{Method \code{get_full_res_image()}}{
This function is a wrapper for a Python function that retrieves full resolution images.


The function downloads an image with the specified feature ID and additional parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$get_full_res_image(
  featureid,
  thread_number = 100,
  bbox = NULL,
  mosaic = FALSE,
  srsname = "EPSG:4326",
  outputdirectory = getwd(),
  image_format = "jpeg",
  filename = "Maxar_Download"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{featureid}}{A character string representing the unique ID of the feature for which the image is required.}

\item{\code{thread_number}}{An integer indicating the number of threads to use for the download process. Default is 100.}

\item{\code{bbox}}{A character string representing the bounding box coordinates in the format 'xmin, ymin, xmax, ymax'. If NULL, the bounding box will be determined based on the feature ID. Default is NULL.}

\item{\code{mosaic}}{A logical value indicating whether to mosaic the images or not. If TRUE, images covering the defined area will be combined into a single image. Default is FALSE.}

\item{\code{srsname}}{A character string representing the spatial reference system to be used for the image. Default is 'EPSG:4326'.}

\item{\code{outputdirectory}}{A character string representing the directory where the image should be saved. If NULL, the image will be saved in the current working directory. Default is NULL.}

\item{\code{image_format}}{A character string representing the format of the image file to be downloaded. Default is 'jpeg'.}

\item{\code{filename}}{A character string representing the name of the file to be saved. Default is "Maxar_Download".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The function returns the result of the Python function call. The nature of this result depends on the Python function implementation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
