\name{gamObject}
\alias{gamObject}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Fitted gam object}
\description{A fitted GAM object returned by function \code{gam} and of class
\code{"gam"} inheriting from classes \code{"glm"} and \code{"lm"}. Method
functions \code{anova}, \code{logLik}, \code{influence}, \code{plot},
\code{predict}, \code{print}, \code{residuals} and \code{summary} exist for
this class.

All compulsory elements of \code{"glm"} and \code{"lm"} objects are present,
but the fitting method for a GAM is different to a linear model or GLM, so
that the elements relating to the QR decomposition of the model matrix are
absent.
}

\value{ A \code{gam} object has the following elements:

\item{aic}{AIC of the fitted model: bear in mind that the degrees of freedom
used to calculate this are the effective degrees of freedom of the model, and
the likelihood is evaluated at the maximum of the penalized likelihood in most
cases, not at the MLE.}

\item{assign}{Array whose elements indicate which model term (listed in
\code{pterms}) each parameter relates to: applies only to non-smooth terms.}

\item{boundary}{did parameters end up at boundary of parameter space?} 

\item{call}{the matched call (allows \code{update} to be used with \code{gam} objects, for example). }

\item{cmX}{column means of the model matrix --- useful for componentwise CI calculation.}

\item{coefficients}{the coefficients of the fitted model. Parametric
          coefficients are  first, followed  by coefficients for each
          spline term in turn.}

\item{control}{the \code{gam} control list used in the fit.}

\item{converged}{indicates whether or not the iterative fitting method converged.} 

\item{data}{the original supplied data argument (for class \code{"glm"} compatibility).}

\item{deviance}{model deviance (not penalized deviance).}

\item{df.null}{null degrees of freedom.} 

\item{df.residual}{effective residual degrees of freedom of the model.}

\item{edf}{estimated degrees of freedom for each model parameter. Penalization
means that many of these are less than 1.}

\item{family}{family object specifying distribution and link used.}

\item{fit.method}{ Character string describing the multiple GCV/UBRE smoothing
parameter estimation method used.}

\item{fitted.values}{fitted model predictions of expected value for each
          datum.}

\item{formula}{the model formula.}

\item{full.sp}{full array of smoothing parameters multiplying penalties (excluding any contribution 
from \code{min.sp} argument to \code{gam}). May be larger than \code{sp} if some terms share 
smoothing parameters, and/or some smoothing parameter values were supplied in the \code{sp} argument
of \code{\link{gam}}.}


%%\item{full.formula}{the model formula with each smooth term fully
%%  expanded and with option arguments given explicitly (i.e. not with reference
%%  to other variables) - useful for later prediction from the model.}

\item{gcv.ubre}{The minimized GCV or UBRE score.}


\item{hat}{array of elements from the leading diagonal of the `hat' (or `influence') matrix. 
Same length as response data vector.}

\item{iter}{number of iterations of P-IRLS taken to get convergence.}

\item{linear.predictors}{fitted model prediction of link function of
expected value for  each datum.}

\item{method}{One of \code{"GCV"} or \code{"UBRE"}, depending on the fitting
criterion used.}

\item{mgcv.conv}{ A list of convergence diagnostics relating to the
\code{"magic"} parts of smoothing parameter estimation - this will not be very meaningful for pure \code{"outer"}
estimation of smoothing parameters. The items are: \code{full.rank}, The apparent rank of the problem given the model matrix and 
constraints; \code{rank}, The numerical rank of the problem;
 \code{fully.converged}, \code{TRUE} is multiple GCV/UBRE converged by meeting 
convergence criteria and \code{FALSE} if method stopped with a steepest descent step 
failure; \code{hess.pos.def}Was the hessian of the GCV/UBRE score positive definite at 
smoothing parameter estimation convergence?; \code{iter} How many iterations were required to find the smoothing parameters?
\code{score.calls}, and how many times did the GCV/UBRE score have to be
evaluated?; \code{rms.grad}, root mean square of the gradient of the GCV/UBRE score at 
convergence.
} % end of mgcv.conv listing

\item{min.edf}{Minimum possible degrees of freedom for whole model.}

\item{model}{model frame containing all variables needed in original model fit.}

\item{na.action}{The \code{\link{na.action}} used in fitting.}

\item{nsdf}{number of parametric, non-smooth, model terms including the
          intercept.}

\item{null.deviance}{deviance for single parameter model.} 

\item{offset}{model offset.}

\item{outer.info}{If `outer' iteration has been used to fit the model (see
\code{\link{gam.method}}) then this is present and contains whatever was
returned by the optimization routine used (currently \code{\link{nlm}} or \code{\link{optim}}). }

\item{prior.weights}{prior weights on observations.} 

\item{pterms}{\code{terms} object for strictly parametric part of model.}

\item{rank}{apparent rank of fitted model.}

\item{residuals}{the working residuals for the fitted model.}

\item{sig2}{estimated or supplied variance/scale parameter.}

\item{smooth}{list of smooth objects, containing the basis information for each term in the 
model formula in the order in which they appear. These smooth objects are what gets returned by
the \code{\link{smooth.construct}} objects.}

\item{sp}{estimated smoothing parameters for the model. These are the underlying smoothing
parameters, subject to optimization. For the full set of smoothing parameters multiplying the 
penalties see \code{full.sp}. }

\item{terms}{\code{terms} object of \code{model} model frame.}

\item{Vp}{estimated covariance matrix for the parameters. This is a Bayesian
posterior covariance matrix that results from adopting a particular Bayesian
model of the smoothing process. Paricularly useful for creating
credible/confidence intervals.}

\item{Ve}{frequentist estimated covariance matrix for the parameter
estimators. Particularly useful for testing whether terms are zero. Not so
useful for CI's as smooths are usually biased.}

\item{weights}{final weights used in IRLS iteration.}

\item{y}{response data.}

}

\references{

A Key Reference on this implementation:

Wood, S.N. (2006) Generalized Additive Models: An Introduction with R. Chapman
& Hall/ CRC, Boca Raton, Florida

Key Reference on GAMs generally:

Hastie (1993) in Chambers and Hastie (1993) Statistical Models in S. Chapman
and Hall.

Hastie and Tibshirani (1990) Generalized Additive Models. Chapman and Hall.

}
\author{ Simon N. Wood \email{simon.wood@r-project.org}}

\section{WARNINGS }{ This model object is different to that described in
Chambers and Hastie (1993) in order to allow smoothing parameter estimation etc.

} 

\seealso{\code{\link{gam}}}




\keyword{models} \keyword{smooth} \keyword{regression}%-- one or more ..







