% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{find_shift_factor}
\alias{find_shift_factor}
\title{Function that calculates a value used to shift predictor}
\usage{
find_shift_factor(x)
}
\arguments{
\item{x}{a numeric vector.}
}
\value{
A numeric value that can be used to shift \code{x} to positive values.
If all values are positive, or if \code{x} is binary then 0 is returned.
}
\description{
Function that calculates a value used to shift predictor
}
\details{
For details on why shifting is necessary see the corresponding section in the
documentation of \code{\link[=mfp2]{mfp2()}}.

This function implements the formula in Section 4.7 of Royston and
Sauerbrei (2008).
}
\examples{
x = 1:1000
find_shift_factor(x)

}
\references{
Royston, P., and Sauerbrei, W., 2008. \emph{Multivariable Model - Building:
A Pragmatic Approach to Regression Anaylsis based on Fractional Polynomials
for Modelling Continuous Variables. John Wiley & Sons.}
}
