% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{mf.general}
\alias{mf.general}
\alias{mf.general.default}
\alias{mf.general.formula}
\title{General meta-features}
\usage{
mf.general(...)

\method{mf.general}{default}(x, y, features = "all", ...)

\method{mf.general}{formula}(formula, data, features = "all", ...)
}
\arguments{
\item{...}{Not used}

\item{x}{A data.frame contained only the input attributes}

\item{y}{a factor response vector with one label for each row/component of x.}

\item{features}{A list of features names or \code{"all"} to include all them.}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class
The details section describes the valid values for this group.}
}
\value{
A list named by the requested meta-features.
}
\description{
General meta-features include general information related to the dataset at
hand. It is also known as simple measures.
}
\details{
The following features are allowed for this method:
 \describe{
   \item{"defective.instances"}{Represents the proportion of instances with
     missing values in the dataset.}
   \item{"dimensionality"}{Represents the ratio between the number of
     attributes and the number of instances constituting the dataset.}
   \item{"majority.class"}{Represents the proportion of instances that
     belongs to the majority class. It is also known as default accuracy.}
   \item{"missing.values"}{Represents the proportion of missing values in
     the dataset.}
   \item{"nattribute"}{Represents the total number of attributes in the
     dataset.}
   \item{"nbinary"}{Represents the total of binary attributes in the
     dataset. It includes categorical and numeric values that have just 2
     different values.}
   \item{"nclasse"}{Represents the total number of output values (classes) in
     the dataset.}
   \item{"ninstance"}{Represents the total number of instances (also named
     samples or observations) in the dataset.}
   \item{"nnumeric"}{Represents the number of numeric attributes in the
     dataset.}
   \item{"nsymbolic"}{Represents the number of categorical attributes in the
     dataset. This is the same as the number of factor columns.}
   \item{"pbinary"}{Represents the proportion of binary attributes in the
     dataset.}
   \item{"pnumeric"}{Represents the proportion of numeric attributes in the
     dataset.}
   \item{"psymbolic"}{Represents the proportion of symbolic attributes in the
     dataset.}
   \item{"sdclass"}{Represents the standard deviation of the class
     distribution in the dataset.}
 }
}
\examples{
## Extract all metafeatures
mf.general(Species ~ ., iris)

## Extract some metafeatures
small.iris <- iris[1:100, ]
mf.general(small.iris[1:4], small.iris[5], c("nclasse", "dimensionality"))
}
\references{
Michie, E. D., Spiegelhalter, D. J., & Taylor, C. C. (1994).
   Machine Learning , Neural and Statistical Classification.
   Technometrics, 37(4), 459.

 Lindner, G., & Studer, R. (1999). AST: Support for Algorithm Selection with
   a CBR Approach. Principles of Data Mining and Knowledge Discovery, 1704,
   418-423.

 Castiello, C., Castellano, G., & Fanelli, A. M. (2005). Meta-data:
   Characterization of Input Features for Meta-learning. In Proceedings of
   the 2nd International Conference on Modeling Decisions for Artificial
   Intelligence (Vol. 3558, pp. 457-468).
}
\seealso{
Other meta.features: \code{\link{mf.discriminant}},
  \code{\link{mf.infotheo}}, \code{\link{mf.landmarking}},
  \code{\link{mf.model.based}},
  \code{\link{mf.statistical}}
}

