% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{gev.mle}
\alias{gev.mle}
\title{Generalized extreme value maximum likelihood estimates for various quantities of interest}
\usage{
gev.mle(dat, args = c("loc", "scale", "shape", "quant", "Nmean", "Nquant"), N,
  p, q)
}
\arguments{
\item{dat}{sample vector of excesses}

\item{args}{vector of strings indicating which arguments to return the maximum likelihood values for.}

\item{N}{size of block over which to take maxima. Required only for \code{args} \code{Nmean} and \code{Nquant}.}

\item{p}{tail probability. Required only for \code{arg} \code{quant}.}

\item{q}{level of quantile for maxima of \code{N} exceedances. Required only for \code{args} \code{Nquant}.}
}
\value{
named vector with maximum likelihood estimated parameter values for arguments \code{args}
}
\description{
#' This function calls the \code{fgev} routine on the sample of excesses and returns maximum likelihood
estimates for all quantities of interest, including scale and shape parameters, quantiles and value-at-risk,
expected shortfall and mean and quantiles of maxima of \code{N} threshold exceedances
}
\examples{
dat <- evd::rgev(n = 100, shape = 0.2)
gev.mle(dat = dat, N = 100, p = 0.01, q = 0.5)
}
