\name{dataSynthesis}
\alias{dataSynthesis}

\title{Build a Standard Plotting Data Set for a Given NONR Run}
\description{

	\code{dataSynthesis} scavenges columns from the \file{TAB} file, the \file{par.TAB} file, and the 
	underlying dataset, returning just observation records (\code{EVID==0}) that are not
  commented.  The second two files are limited to the first record per ID. Columns 
  to scavenge are supplied by \code{grp, cont.cov, cat.cov, par.list, and eta.list}.
  All \file{TAB} file columns are returned, plus first instance of \sQuote{scavenge} columns from 
  either the \file{par} file or the parent data set (in that order) unless already present. Exception:
  \code{par.list} and \code{eta.list} items are not sought in the underlying dataset.
 
}
\usage{
  dataSynthesis(
	run, 
	project=getwd(), 
	logtrans = FALSE,
	grp = NULL, 
	grpnames = NULL,
	cont.cov = NULL,
	cat.cov = NULL,
	par.list = NULL,
	eta.list = NULL,
	missing = -99,
	rundir  = filename(project, run),
	ctlfile = filename(rundir,run,'.ctl'),
	outfile = filename(rundir,run,'.lst'),
	datfile = getdname(ctlfile),
	...
)
}

\arguments{
  \item{run}{a control stream name, typically integer}
 
  \item{project}{the directory containing the NONMEM run directories}

  \item{logtrans}{whether to transform the NONMEM output variables DV, PRED, and IPRED. Default: \code{FALSE}.}

  \item{grp}{item in NONMEM datafile or output table file that can be used to condition
  	  plots generated by PLOTR.  Default value is \code{NULL}. Example:
  \code{grp=c('SEX')}.  Can be more than one, e.g,. \code{grp=c('SEX','TRT')}.}

  \item{grpnames}{optional vector of names for
  \code{grp} item. Vector length must equal number of conditions in
  \code{grp} and must have an order corresponding to an increasing sort
  of \code{grp}.  Default value is \code{NULL}. Example:
  \code{grpnames=c('Male','Female')}}

  \item{cont.cov}{vector of
  continuous covariate names. Names must match those used as column
  headers in \code{datfile}.  Values are retrieved from \code{datfile}
  so they do not need to be part of the NONMEM \$TABLE step. Default
  value is \code{NULL}.  Example: \code{cont.cov=c('AGE','WT','CLCR')}}

  \item{cat.cov}{vector of categorical covariate names. Names must match
  those used as column headers in \code{datfile}.  Values are retrieved
  from \code{datfile} so they do not need to be part of the NONMEM
  \$TABLE step. Default value is \code{NULL}.  Example:
  \code{cat.cov=c('SEX','FOOD')}} 

  \item{par.list}{vector of NONMEM model
  	  parameter names.  Values are retrieved from \file{*par.TAB} created in
  	  NONMEM. Default value is \code{NULL}.  This can be a superset of parameters
  but only those present in NONMEM output table will be used. Example:
  \code{par.list=c('CL','V','V2','Q')}} 

  \item{eta.list}{vector of NONMEM
  	  model random effect names. Values are retrieved from \file{*par.TAB} created
  	  in NONMEM. Default value is \code{NULL}. This can be a superset of random
  parameters but only those present in NONMEM output table will be used.
  Example: \code{eta.list=c('ETA1','ETA2','ETA3','ETA4')}}

  \item{missing}{numeric item that defines value used to represent
  missing items in the NONMEM data file. Default value is '-99'.}

  \item{ctlfile}{Path and filename for the NONMEM control stream (\file{*.ctl}).}

  \item{outfile}{Path and filename for the NONMEM output file (\file{*.lst}).}

  \item{datfile}{Path and filename for the source dataset, as in DATA record in \file{*.ctl}.}

  \item{rundir}{Path for the NONMEM run directory (\file{project/*}).}

  \item{\dots}{extra arguments}
}
\value{data.frame}
\references{\url{http://metrumrg.googlecode.com}}
\author{Tim Bergsma}
\seealso{
	\itemize{
		\item \code{\link{diagnosticPlots}}
		\item \code{\link{dataFormat}}
	}
}
\keyword{manip}

