% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist.r
\name{mjs_histogram}
\alias{mjs_histogram}
\title{Plot Histograms with MetrisGraphics}
\usage{
mjs_histogram(mjs, bar_margin = 1, bins = NULL)
}
\arguments{
\item{mjs}{metricsgraphics plot object}

\item{bar_margin}{space between bars (defaults to \code{1})}

\item{bins}{numbenr of bins for the histogram (\code{NULL} == let MetricsGraphcis.js library compute)}
}
\value{
metricsgraphics plot object
}
\description{
Given a numeric vector or a data frame and numeric column name (bare or quoted),
plot a histogram with the specified parameter. This function automatically a y
axis label "Frequency" which you can override with a call to
\code{mjs_labs}.
}
\examples{
movies <- ggplot2movies::movies[sample(nrow(ggplot2movies::movies), 1000), ]

mjs_plot(movies$rating) \%>\% mjs_histogram()

mjs_plot(movies, rating) \%>\%
  mjs_histogram() \%>\%
  mjs_labs(x_label="Histogram of movie ratings")

mjs_plot(movies$rating) \%>\%
  mjs_histogram(bins=30)

mjs_plot(runif(10000)) \%>\%
  mjs_histogram() \%>\%
  mjs_labs(x_label="runif(10000)")
}

