% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/metricsgraphics.R
\name{mjs_point}
\alias{mjs_point}
\title{metricsgraphics.js scatterplot "geom"}
\usage{
mjs_point(mjs, point_size = 2.5, least_squares = FALSE,
  size_accessor = NULL, color_accessor = NULL, color_type = "number",
  color_range = c("blue", "red"), size_range = c(1, 5), x_rug = FALSE,
  y_rug = FALSE)
}
\arguments{
\item{mjs}{plot object}

\item{point_size}{the radius of the dots in the scatterplot}

\item{least_squares}{add a least squares line? (default: \code{FALSE} - no)}

\item{size_accessor}{bare or quoted name of a column to use to scale the size of the points}

\item{color_accessor}{bare or quoted name of a column to use to scale the color of the points}

\item{color_type}{specifies whether the color scale is quantitative or qualitative.
By setting this option to category, you can color the points according to some other discrete value}

\item{color_range}{the range of colors, used to color different groups of points.}

\item{size_range}{specifies the range of point sizes, when point sizes are mapped to data}

\item{x_rug}{show a "rug" plot next to the x axis? (default: \code{FALSE} - no)}

\item{y_rug}{show a "rug" plot next to the y axis? (default: \code{FALSE} - no)}
}
\value{
metricsgraphics object
}
\description{
This function adds a point/scatterplot "geom" to a metricsgraphics.js html widget.
}
\examples{
mtcars \%>\%
 mjs_plot(x=wt, y=mpg, width=400, height=300) \%>\%
 mjs_point(least_squares=TRUE)
}

