% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_meteo_and_topo.R
\name{with_meteo}
\alias{with_meteo}
\title{Ensure meteo object is ready to create an interpolator object}
\usage{
with_meteo(meteo, verbose = getOption("meteoland_verbosity", TRUE))
}
\arguments{
\item{meteo}{meteo object}

\item{verbose}{Logical indicating if the function must show messages and info.
Default value checks \code{"meteoland_verbosity"} option and if not set, defaults
to TRUE. It can be turned off for the function with FALSE, or session wide with
\code{options(meteoland_verbosity = FALSE)}}
}
\value{
invisible meteo object ready to pipe in the interpolator creation
}
\description{
Check integrity of meteo objects
}
\details{
This function is the first step in the creation of a meteoland interpolator,
ensuring the meteo provided contains all the required elements
}
\examples{
# example meteo
data(meteoland_meteo_example)
with_meteo(meteoland_meteo_example)

}
\seealso{
Other interpolator functions: \code{\link{add_topo}()},
\code{\link{create_meteo_interpolator}()},
\code{\link{get_interpolation_params}()}, \code{\link{read_interpolator}()},
\code{\link{set_interpolation_params}()}, \code{\link{write_interpolator}()}
}
