% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umbrella_XLS.R
\name{umbrella.xls}
\alias{umbrella.xls}
\title{Automatically conduct an umbrella review and export results outside of R}
\usage{
umbrella.xls(
  input_file = NULL,
  sheet = 1,
  output_path = "",
  output_name = "",
  factors_to_analyze = "",
  evidence = NULL,
  plot_results = FALSE
)
}
\arguments{
\item{input_file}{path indicating the folder where the dataset (stored in an excel file) is located.}

\item{sheet}{the number of the excel sheet where the data are located.}

\item{output_path}{path indicating the folder where the results to be generated.}

\item{output_name}{name of the files created by the function.}

\item{factors_to_analyze}{the name(s) of factors to analyze. Can be either a character string indicating the name of the factor to analyze or a vector indicating the names of the factors to analyze. By default, all the factors are analyzed.}

\item{evidence}{criteria used to stratify evidence. Must be either "Ioannidis" or "GRADE".}

\item{plot_results}{indicate whether a forest plot of the results is returned. Must be either TRUE or FALSE.}
}
\value{
The \code{umbrella.xls()} function returns several elements including
\tabular{ll}{
\code{csv} \tab a csv file containing the results of the umbrella review.\cr
\tab \cr
\code{pdf} \tab a pdf file containing the plot of the results (only if requested, i.e., the \code{plot_results}\cr
\tab argument is set as TRUE).\cr
\tab \cr
\code{html} \tab an HTML file containing the results of the umbrella review.\cr
}
}
\description{
The \code{umbrella.xls} function allows to automatically perform an umbrella review and to export results outside of R.
}
\details{
This function implicitly calls the \code{view.errors.umbrella()} to check the formatting of the data,
the \code{umbrella()} function to perform calculations, the \code{add.evidence()} function to stratify evidence (limited to "Ioannidis" and "GRADE" classifications for now)
and the \code{forest()} function to generate a visual representation of the results.
}
\examples{
if(interactive()){
### perform an umbrella review according to the GRADE criteria.
### the umbrella review is restricted to the factor "Pharmacological"
### Note that the df.SMD should be stored under a .xls or .xlsx format
umbrella.xls(input_file = file.choose(),
             sheet = 1,
             output_path = choose.dir(),
             output_name = "Pharmacological_Ioannidis",
             factors_to_analyze = c("Pharmacological"),
             evidence = "GRADE",
             plot_results = TRUE)
}
}
\seealso{
\code{\link{umbrella}()}\cr
\code{\link{add.evidence}()}\cr
\code{\link{summary.umbrella}()}
}
