% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_variables}
\alias{check_variables}
\title{Check Variable Names}
\usage{
check_variables(data, metacore, dataset_name = NULL)
}
\arguments{
\item{data}{Dataset to check}

\item{metacore}{metacore object that only contains the specifications for the
dataset of interest.}

\item{dataset_name}{Optional string to specify the dataset. This is only
needed if the metacore object provided hasn't already been subsetted.}
}
\value{
message if the dataset matches the specification and the dataset, and error otherwise
}
\description{
This function checks the variables in the dataset against the variables
defined in the metacore specifications. If everything matches the function
will return `TRUE` and a message starting everything is as expected. If there
are additional or missing variables and error will explain the discrepancies
}
\examples{
library(haven)
library(metacore)
library(magrittr)
load(metacore_example("pilot_ADaM.rda"))
spec <- metacore \%>\% select_dataset("ADSL")
data <- read_xpt(metatools_example("adsl.xpt"))
check_variables(data, spec)
}
