% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{metOption}
\alias{metOption}
\title{Get Option with Partial Matching}
\usage{
metOption(x, default = NULL)
}
\arguments{
\item{x}{a character string holding an option name}

\item{default}{the value returned if option is not set}
}
\description{
Gets an option value.  Selects the longest among all leading partial matches.
(Ties are broken by sorting and taking the first.)
This allows multiple options to be set simultaneously, and allows a subset of these to be overridden.
The intended effect is similar to cascading style sheets.
}
\examples{

library(magrittr)
library(dplyr)
library(csv)
x <- as.csv(system.file(package = 'metaplot', 'extdata/theoph.csv'))
x \%<>\% pack

multiplot(
x \%>\% metaplot(conc, gg = F),
x \%>\% metaplot(conc, time, gg = F),
x \%>\% metaplot(conc, arm, gg = F),
x \%>\% metaplot(conc, arm,  gg = T)
)

# Add a reference line at 9 mg/L
x$conc \%<>\% structure(reference = 9)

# Make the reference line green universally.
options(metaplot_ref_col = 'green')

# Make the reference line orange for density plots
options(metaplot_ref_col_dens = 'orange')

multiplot(
x \%>\% metaplot(conc, gg = F),
x \%>\% metaplot(conc, time, gg = F),
x \%>\% metaplot(conc, arm, gg = F),
x \%>\% metaplot(conc, arm,  gg = T)
)

# Restore defaults
options(metaplot_ref_col = NULL)
options(metaplot_ref_col_dens = NULL)
}
\seealso{
\code{\link{getOption}}
}
