% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_as.R
\name{utils_as}
\alias{utils_as}
\alias{as_numeric}
\alias{as_integer}
\alias{as_logical}
\alias{as_character}
\alias{as_factor}
\title{Encode variables to a specific format}
\usage{
as_numeric(.data, ..., .keep = "all", .pull = FALSE)

as_integer(.data, ..., .keep = "all", .pull = FALSE)

as_logical(.data, ..., .keep = "all", .pull = FALSE)

as_character(.data, ..., .keep = "all", .pull = FALSE)

as_factor(.data, ..., .keep = "all", .pull = FALSE)
}
\arguments{
\item{.data}{A data frame or a vector.}

\item{...}{<\code{\link[=dplyr_tidy_select]{tidy-select}}>. If \code{.data} is a data
frame, then \code{...} are the variable(s) to encode to a format.}

\item{.keep}{Allows you to control which columns from \code{.data} are
retained in the output.
\itemize{
\item \code{"all"} (default) retains all variables.
\item \code{"used"} keeps any variables used to make new variables.
}}

\item{.pull}{Allows you to pull out the last column of the output. It is
useful in combination with \code{.keep = "used"}. In this case, a vector
will be created with the used column.}
}
\value{
An object of the same class of \code{.data} with the variables in
\code{...} encoded to the specified format.
}
\description{
Function to quick encode vector or columns to a specific format.
\itemize{
\item \code{as_numeric()}: Encode columns to numeric using
\code{\link{as.numeric}()}.
\item \code{as_integer()}: Encode columns to integer using
\code{\link{as.integer}()}.
\item \code{as_logical()}: Encode columns to logical using
\code{\link{as.logical}()}.
\item \code{as_character()}: Encode columns to character using
\code{\link{as.character}()}.
\item \code{as_factor()}: Encode columns to factor using
\code{\link{as.factor}()}.
}
}
\examples{
\donttest{
library(metan)
library(tibble)
df <-
  tibble(y = rnorm(5),
         x1 = c(1:5),
         x2 = c(TRUE, TRUE, FALSE, FALSE, FALSE),
         x3 = letters[1:5],
         x4 = as.factor(x3))
df

# Convert y to integer
as_integer(df, y)
as_integer(df$y)

# convert x3 to factor
as_factor(df, x3)

# Convert all columns to character
as_character(df, everything())

# Convert x2 to numeric and coerce to a vector
as_numeric(df, x2, .keep = "used", .pull = TRUE)
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
