% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDFs_collect.R
\name{PDFs_collect}
\alias{PDFs_collect}
\title{Attempts to download PDFs from multiple DOI links.}
\usage{
PDFs_collect(
  aDataFrame,
  DOIcolumn,
  FileNamecolumn,
  directory = getwd(),
  randomize = FALSE,
  seed = NULL,
  buffer = FALSE,
  validatePDF = TRUE,
  quiet = FALSE,
  showSummary = TRUE,
  WindowsProxy = FALSE
)
}
\arguments{
\item{aDataFrame}{A data frame containing a column of DOIs and a column of
individual file names for each downloaded PDF.}

\item{DOIcolumn}{The label of the column containing all the DOI links.}

\item{FileNamecolumn}{The label of the column containing all the strings 
that will be used to rename the downloaded files.}

\item{directory}{A string of the location (directory) were downloaded PDF
files are to be saved.  NOTE: helps to have this directory created before
initializing the \code{PDFs_collect} function.}

\item{randomize}{When \code{TRUE} will attempt to download PDFs in a random
order.  This may be necessary to ensure that host websites do not have
their HTML and files repeatedly accessed.}

\item{seed}{An integer used to enforce repeatability when randomly 
downloading PDFs.}

\item{buffer}{When \code{TRUE} will randomly delay the downloads by a few
seconds (with a mean 4 seconds and a range of 1 to 20 seconds). Another
strategy to avoid quickly and repeatedly accessing host websites.}

\item{validatePDF}{When \code{TRUE} will only save to files that are valid
PDF documents.  When \code{FALSE} will save all candidate files, even if
they are not valid PDF formats.}

\item{quiet}{When \code{FALSE} does not print to console individual 
download progress and summary.}

\item{showSummary}{When \code{FALSE} does not print overall summary of download
successes and failures.}

\item{WindowsProxy}{When \code{TRUE} significantly improves download success 
for computers running Windows; when \code{FALSE} on a Windows based 
computer, you may only be able to download 30 to 50 PDFs at a time before 
a connection error occurs and halts all downloads (e.g., 
\code{InternetOpenUrl failed} error).}
}
\value{
The data frame with new column containing download-outcome successes.
}
\description{
Tries to download a collection of PDF files using multiple digital object 
identifier (DOI) links.  Updates a data frame with the success of these 
downloads.  The function is a wrapper for \code{\link{PDF_download}}.  NOTE: 
A single DOI may generate multiple PDF files.  \strong{If running downloader 
in Windows, having \code{"WindowsProxy = TRUE"} will significantly improve 
download success.}
}
\examples{
\dontrun{

data(example_references_metagear)
someRefs <- effort_initialize(example_references_metagear)  
dir.create("metagear_downloads")      
PDFs_collect(aDataFrame = someRefs, DOIcolumn = "DOI", 
             FileNamecolumn = "STUDY_ID", directory = "metagear_downloads",
			WindowsProxy = TRUE)
}

}
\seealso{
\code{\link{PDF_download}}
}
